<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-07-04 13:42
 */
interface BindsettlementDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Bindsettlement 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param bindsettlement primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Bindsettlement bindsettlement
 	 */
	public function insert($bindsettlement);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Bindsettlement bindsettlement
 	 */
	public function update($bindsettlement);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserid($value);

	public function queryByEmployeeid($value);

    public function queryBySettlementway($value);

	public function queryBySettlementwayid($value);

	public function queryByProjectid($value);

	public function queryByValue($value);

	public function queryByComment($value);

	public function queryByDeleted($value);


	public function deleteByUserid($value);

	public function deleteByEmployeeid($value);

    public function deleteBySettlementway($value);

	public function deleteBySettlementwayid($value);

	public function deleteByProjectid($value);

	public function deleteByValue($value);

	public function deleteByComment($value);

	public function deleteByDeleted($value);


}
?>